VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Authors"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Description = "Add, Update and Delete Author Data"
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'Enum Custom Errors
Public Enum CustomErrors
   INVALID_LENGTH_STRING = &H80040208
   MISSING_HYPHEN = &H80040209
   DATA_NOT_NUMERIC = &H8004020A
   MISSING_SPACE = &H8004020B
   INVALID_NUMERIC_RANGE = &H8004020C
   INVALID_STATE_ABBREVIATION = &H8004020D
   INVALID_ZIP_CODE_LENGTH = &H8004020E
   OPEN_DATABASE_ERROR = &H8004020F
   NO_MATCH_ON_LAST_NAME = &H80040210
   NO_MATCH_ON_FIRST_NAME = &H80040211
End Enum

'Declare private variables
Private m_lngError As Long
Public Function Delete(ByVal strSSN As String, ByVal strFirstName _
   As String, ByVal strLastName As String) As Long
Attribute Delete.VB_Description = "Delete Authors from the database. Returns zero on success or the error number on failure."
Attribute Delete.VB_HelpID = 3
   
   'Delcare variables
   Dim strSQL As String
   On Error GoTo DeleteErr
   
   '***************************************************************
   'Perform data validations
   '***************************************************************
   
   'Perform SSN validation
   If Not SSN_Validation(strSSN) Then
      GoTo DeleteErr
   End If
   
   'Verify the first name is not > 20 characters
   If Len(strFirstName) > 20 Then
      strFirstName = Left$(strFirstName, 20)
   End If

   'Verify the last name is not > 40 characters
   If Len(strLastName) > 40 Then
      strLastName = Left$(strLastName, 40)
   End If
   
   '***************************************************************
   'Delete the Author from the database
   '***************************************************************
   
   'Connect to the database
   If Not OpenDatabase Then
      m_lngError = OPEN_DATABASE_ERROR
      Err.Raise OPEN_DATABASE_ERROR, "Delete", _
         "Open Database Error"
   End If
   
   'Delete the Author from the database
   On Error GoTo SQLErr
   Set g_objCmd.ActiveConnection = g_objConn
   g_objCmd.CommandText = "{? = call dbo.up_parmdel_authors ('" & _
      strSSN & "','" & strLastName & "','" & strFirstName & "')}"
   g_objCmd(0).Direction = adParamReturnValue
   g_objCmd.Execute
   On Error GoTo 0
   
   On Error GoTo DeleteErr
   Select Case g_objCmd(0)
      Case 0
         'Normal return code
      Case 1
         'Last name does not match
         m_lngError = NO_MATCH_ON_LAST_NAME
         Err.Raise NO_MATCH_ON_LAST_NAME, "Delete", _
            "Last Name Passed Does Not Last Name On Database"
      Case 2
         'First name does not match
         m_lngError = NO_MATCH_ON_FIRST_NAME
         Err.Raise NO_MATCH_ON_FIRST_NAME, "Delete", _
            "First Name Passed Does Not First Name On Database"
   End Select
   
   'Close the database
   Call CloseDatabase
   
   'Return to caller
   Delete = 0
   Exit Function
   
SQLErr:
   'Your error handling code here
   'Loop through the ADO errors collection
   Delete = 1
   'Close the database
   Call CloseDatabase
   Exit Function
DeleteErr:
   'Your error handling code here
   Delete = m_lngError  'The error raised by the validation routines
   'Close the database
   Call CloseDatabase
End Function

Public Function Update(ByVal strSSN As String, Optional ByVal _
   varFirstName As Variant, Optional ByVal varLastName As Variant, _
   Optional ByVal varPhone As Variant, Optional ByVal varAddress _
   As Variant, Optional ByVal varCity As Variant, Optional ByVal _
   varState As Variant, Optional ByVal varZip As Variant, Optional _
   ByVal varContract As Variant) As Long
Attribute Update.VB_Description = "Updates Authors on the database. Returns zero on success or the error number on failure."
Attribute Update.VB_HelpID = 2
   
   'Delcare variables
   Dim strFirstName, strLastName, strPhone, strAddress, strCity, _
      strState, strZip, strSQL As String
   Dim bytContract As Byte
   On Error GoTo UpdateErr
   
   '***************************************************************
   'Perform data validations
   '***************************************************************
   
   'Perform SSN validation
   If Not SSN_Validation(strSSN) Then
      GoTo UpdateErr
   End If
   
   'Convert to string if present
   If Not IsMissing(varFirstName) Then
      strFirstName = CStr(varFirstName)
      'Verify the first name is not > 20 characters
      If Len(strFirstName) > 20 Then
         strFirstName = Left$(strFirstName, 20)
      End If
   End If
   
   'Convert to string if present
   If Not IsMissing(varLastName) Then
      strLastName = CStr(varLastName)
      'Verify the last name is not > 40 characters
      If Len(strLastName) > 40 Then
         strLastName = Left$(strLastName, 40)
      End If
   End If
   
   If Not IsMissing(varPhone) Then
      'Convert phone to a string and perform Phone validation
      strPhone = CStr(varPhone)
      If Not Phone_Validation(strPhone) Then
         GoTo UpdateErr
      End If
   End If
   
   'Convert to string if present
   If Not IsMissing(varAddress) Then
      strAddress = CStr(varAddress)
      'Verify the address is not > 40 characters
      If Len(strAddress) > 40 Then
         strAddress = Left$(strAddress, 40)
      End If
   End If
   
   'Convert to string if present
   If Not IsMissing(varCity) Then
      strCity = CStr(varCity)
      'Verify the city is not > 20 characters
      If Len(strCity) > 20 Then
         strCity = Left$(strCity, 20)
      End If
   End If
   
   If Not IsMissing(varState) Then
      'Convert state to a string and perform State validation
      strState = CStr(varState)
      If Not State_Validation(strState) Then
         GoTo UpdateErr
      End If
   End If
   
   'Convert to string if present and validate length
   If Not IsMissing(varZip) Then
      strZip = CStr(varZip)
      If Len(strZip) <> 5 Then
         Err.Raise INVALID_ZIP_CODE_LENGTH, "Add", _
            "Invalid Zip Code Length"
      End If
   End If
   
   If Not IsMissing(varContract) Then
      'Convert contract to a byte and perform Contract validation
      bytContract = CByte(varContract)
      If Not Contract_Validation(bytContract) Then
         GoTo UpdateErr
      End If
   End If
   
   '***************************************************************
   'Update the Author on the database
   '***************************************************************
   
   'Connect to the database
   If Not OpenDatabase Then
      m_lngError = OPEN_DATABASE_ERROR
      Err.Raise OPEN_DATABASE_ERROR, "Update", _
         "Open Database Error"
   End If
   
   'Build the SQL string
   strSQL = "dbo.up_parmupd_authors ('" & strSSN & "','" & _
      IIf(IsMissing(varLastName), "", strLastName) & "','" & _
      IIf(IsMissing(varFirstName), "", strFirstName) & "','" & _
      IIf(IsMissing(varPhone), "", strPhone) & "','" & _
      IIf(IsMissing(varAddress), "", strAddress) & "','" & _
      IIf(IsMissing(varCity), "", strCity) & "','" & _
      IIf(IsMissing(varState), "", strState) & "','" & _
      IIf(IsMissing(varZip), "", strZip) & "','" & _
      IIf(IsMissing(varContract), "", bytContract) & "')"
   
   'Update the Author on the database
   On Error GoTo SQLErr
   g_objConn.Execute strSQL
   On Error GoTo 0
   
   'Close the database
   Call CloseDatabase
   
   'Return to caller
   Update = 0
   Exit Function
   
SQLErr:
   'Your error handling code here
   'Loop through the ADO errors collection
   Update = 1
   'Close the database
   Call CloseDatabase
   Exit Function
UpdateErr:
   'Your error handling code here
   Update = m_lngError  'The error raised by the validation routines
End Function

Public Function Add(ByVal strSSN As String, ByVal strFirstName As _
   String, ByVal strLastName As String, ByVal strPhone As String, _
   ByVal bytContract As Byte, Optional ByVal varAddress As Variant, _
   Optional ByVal varCity As Variant, Optional ByVal varState As _
   Variant, Optional ByVal varZip As Variant) As Long
Attribute Add.VB_Description = "Add new Authors to the database. Returns zero on success or the error number on failure."
Attribute Add.VB_HelpID = 1
   
   'Delcare variables
   Dim strAddress, strCity, strState, strZip, strSQL As String
   On Error GoTo AddErr
   
   '***************************************************************
   'Perform data validations
   '***************************************************************
   
   'Perform SSN validation
   If Not (SSN_Validation(strSSN)) Then
      GoTo AddErr
   End If
   
   'Verify the first name is not > 20 characters
   If Len(strFirstName) > 20 Then
      strFirstName = Left$(strFirstName, 20)
   End If
   
   'Verify the last name is not > 40 characters
   If Len(strLastName) > 40 Then
      strLastName = Left$(strLastName, 40)
   End If
   
   'Perform Phone validation
   If Not Phone_Validation(strPhone) Then
      GoTo AddErr
   End If
   
   'Convert to string if present
   If Not IsMissing(varAddress) Then
      strAddress = CStr(varAddress)
      'Verify the address is not > 40 characters
      If Len(strAddress) > 40 Then
         strAddress = Left$(strAddress, 40)
      End If
   End If
   
   'Convert to string if present
   If Not IsMissing(varCity) Then
      strCity = CStr(varCity)
      'Verify the city is not > 20 characters
      If Len(strCity) > 20 Then
         strCity = Left$(strCity, 20)
      End If
   End If
   
   If Not IsMissing(varState) Then
      'Convert state to a string and perform State validation
      strState = CStr(varState)
      If Not State_Validation(strState) Then
         GoTo AddErr
      End If
   End If
   
   'Convert to string if present and validate length
   If Not IsMissing(varZip) Then
      strZip = CStr(varZip)
      If Len(strZip) <> 5 Then
         m_lngError = INVALID_ZIP_CODE_LENGTH
         Err.Raise INVALID_ZIP_CODE_LENGTH, "Add", _
            "Invalid Zip Code Length"
      End If
   End If
   
   'Perform Contract validation
   If Not Contract_Validation(bytContract) Then
      GoTo AddErr
   End If
   
   '***************************************************************
   'Add the data to the database
   '***************************************************************
   
   'Connect to the database
   If Not OpenDatabase Then
      m_lngError = OPEN_DATABASE_ERROR
      Err.Raise OPEN_DATABASE_ERROR, "Add", _
         "Open Database Error"
   End If
   
   'Build the SQL string
   strSQL = "dbo.up_parmins_authors ('" & strSSN & "','" & _
      strLastName & "','" & strFirstName & "','" & strPhone _
      & "'," & _
      IIf(IsMissing(varAddress), "Null", "'" & strAddress & "'") _
      & "," & _
      IIf(IsMissing(varCity), "Null", "'" & strCity & "'") _
      & "," & _
      IIf(IsMissing(varState), "Null", "'" & strState & "'") _
      & "," & _
      IIf(IsMissing(varZip), "Null", "'" & strZip & "'") _
      & "," & bytContract & ")"
   
   'Add the Author to the database
   On Error GoTo SQLErr
   g_objConn.Execute strSQL
   On Error GoTo 0
   
   'Close the database
   Call CloseDatabase
   
   'Return to caller
   Add = 0
   Exit Function
   
SQLErr:
   'Your error handling code here
   'Loop through the ADO errors collection
   Add = 1
   'Close the database
   Call CloseDatabase
   Exit Function
AddErr:
   'Your error handling code here
   Add = m_lngError  'The error raised by the validation routines
End Function

Private Function State_Validation(ByVal strStateIn As String) As Boolean
Attribute State_Validation.VB_Description = "Validate State Abbreviations"
   'Validate the State Abbreviation passed matches one of the values
   'in the array
   Dim varState As Variant
   Dim intIndex As Integer
   On Error GoTo ValidateErr
   
   'Set the state array with a list of all state abbreviations
   varState = Array("AL", "AK", "AZ", "AR", "CA", "CO", "CT", _
      "DE", "FL", "GA", "HI", "ID", "IL", "IN", "IA", "KS", "KY", _
      "LA", "ME", "MD", "MA", "MI", "MN", "MS", "MO", "MT", "NE", _
      "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "OH", "OK", "OR", _
      "PA", "RI", "SC", "SD", "TN", "TX", "UT", "VT", "VA", "WA", _
      "WV", "WI", "WY")
      
   'Loop through the array looking for a match
   For intIndex = LBound(varState) To UBound(varState)
      If UCase(strStateIn) = CStr(varState(intIndex)) Then
         State_Validation = True
         Exit Function
      End If
   Next
   
   Err.Raise INVALID_STATE_ABBREVIATION, "State_Validation", _
      "Invalid State Abbreviation"
ValidateErr:
   'Your error handling code here
   m_lngError = Err.Number
   State_Validation = False
End Function



Private Function Contract_Validation(ByVal bytContract As Byte) As Boolean
Attribute Contract_Validation.VB_Description = "Validate Contract byte"
   'Validate the Contract Flag passed contains the following
   'data: 0 or 1
   On Error GoTo ValidateErr
   
   'First validate the numeric data
   If Not IsNumeric(bytContract) Then
      Err.Raise DATA_NOT_NUMERIC, "Contract_Validation", _
            "Data not Numeric"
   End If
   
   'Next validate the numeric range
   If bytContract > 1 Then
      Err.Raise INVALID_NUMERIC_RANGE, "Contract_Validation", _
            "Invalid Numeric Range"
   End If
   
   'Next convert True value (-1) to 1
   If bytContract = True Then
      bytContract = 1
   End If
      
   Contract_Validation = True
   Exit Function

ValidateErr:
   'Your error handling code here
   m_lngError = Err.Number
   Contract_Validation = False
End Function

Private Function Phone_Validation(ByVal strPhone As String) As Boolean
Attribute Phone_Validation.VB_Description = "Validate Phone Numbers"
   'Validate the Phone Number passed is in the following
   'format: nnn nnn-nnnn
   Dim intIndex As Integer
   On Error GoTo ValidateErr
   
   'First validate the length of the string
   If Len(strPhone) <> 12 Then
      Err.Raise INVALID_LENGTH_STRING, "Phone_Validation", _
         "Invalid Length String"
   End If
   
   'Next validate the hyphens
   If Mid$(strPhone, 8, 1) <> "-" Then
      Err.Raise MISSING_HYPHEN, "Phone_Validation", _
         "Missing or Misplaced Hyphen"
   End If
   
   'Next validate the spaces (Chr$(32)= Space)
   If Mid$(strPhone, 4, 1) <> Chr$(32) Then
      Err.Raise MISSING_SPACE, "Phone_Validation", _
         "Missing or Misplaced Space"
   End If
   
   'Next validate the numeric data
   For intIndex = 1 To 3
      If Not IsNumeric(Mid$(strPhone, intIndex, 1)) Then
         Err.Raise DATA_NOT_NUMERIC, "Phone_Validation", _
            "Data not Numeric"
      End If
   Next
   For intIndex = 5 To 7
      If Not IsNumeric(Mid$(strPhone, intIndex, 1)) Then
         Err.Raise DATA_NOT_NUMERIC, "Phone_Validation", _
            "Data not Numeric"
      End If
   Next
   For intIndex = 9 To 12
      If Not IsNumeric(Mid$(strPhone, intIndex, 1)) Then
         Err.Raise DATA_NOT_NUMERIC, "Phone_Validation", _
            "Data not Numeric"
      End If
   Next
   
   Phone_Validation = True
   Exit Function

ValidateErr:
   'Your error handling code here
   m_lngError = Err.Number
   Phone_Validation = False
End Function


Private Function SSN_Validation(ByVal strSSN As String) As Boolean
Attribute SSN_Validation.VB_Description = "Validate Social Security Number"
   'Validate the Social Security Number passed is in the following
   'format: nnn-nn-nnnn
   Dim intIndex As Integer
   On Error GoTo ValidateErr
   
   'First validate the length of the string
   If Len(strSSN) <> 11 Then
      Err.Raise INVALID_LENGTH_STRING, "SSN_Validation", _
         "Invalid Length String"
   End If
   
   'Next validate the hyphens
   If Mid$(strSSN, 4, 1) <> "-" Or Mid$(strSSN, 7, 1) <> "-" Then
      Err.Raise MISSING_HYPHEN, "SSN_Validation", _
         "Missing or Misplaced Hyphen"
   End If
   
   'Next validate the numeric data
   For intIndex = 1 To 3
      If Not IsNumeric(Mid$(strSSN, intIndex, 1)) Then
         Err.Raise DATA_NOT_NUMERIC, "SSN_Validation", _
            "Data not Numeric"
      End If
   Next
   For intIndex = 5 To 6
      If Not IsNumeric(Mid$(strSSN, intIndex, 1)) Then
         Err.Raise DATA_NOT_NUMERIC, "SSN_Validation", _
            "Data not Numeric"
      End If
   Next
   For intIndex = 8 To 11
      If Not IsNumeric(Mid$(strSSN, intIndex, 1)) Then
         Err.Raise DATA_NOT_NUMERIC, "SSN_Validation", _
            "Data not Numeric"
      End If
   Next
   
   SSN_Validation = True
   Exit Function

ValidateErr:
   'Your error handling code here
   m_lngError = Err.Number
   SSN_Validation = False
End Function

